<?php

namespace App\Http\Controllers;

use App\Models\CompanyInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class CompanyInfoController extends Controller {
    public function index() {
        $data = CompanyInfo::first();

        return view('company-info', compact('data'));
    }

    public function store(Request $request) {

        $data = CompanyInfo::updateOrCreate(
            ['id' => 1],
            [
                'name'                 => $request->name,
                'legal_name'           => $request->legal_name,
                'website_url'          => $request->website_url,
                'registration_number'  => $request->registration_number,
                'about'                => $request->about,
                'tagline'              => $request->tagline,
                'publication_name'     => $request->publication_name,
                'state'                => $request->state,
                'postal_address'       => $request->postal_address,
                'contact_person_name'  => $request->contact_person_name,
                'contact_person_email' => $request->contact_person_email,
                'phone'                => $request->phone,
                'email'                => $request->email,
                'default_currency'     => $request->default_currency,
                'meta_title'           => $request->meta_title,
                'meta_keyword'         => $request->meta_keyword,
                'meta_description'     => $request->meta_description,
            ]
        );

        $logo = null;

        if ($request->hasFile('logo')) {
            $file_name = $request->file('logo');

            $logo_path = public_path($data->logo);

            if (File::exists($logo_path)) {
                File::delete($logo_path);
            }

            $logo = uploadImage('branch', $file_name);

            $data->update([
                'logo' => $logo,
            ]);
        }

        $favicon = null;

        if ($request->hasFile('favicon')) {
            $file_name = $request->file('favicon');

            $favicon_path = public_path($data->favicon);

            if (File::exists($favicon_path)) {
                File::delete($favicon_path);
            }

            $favicon = uploadImage('branch', $file_name);

            $data->update([
                'favicon' => $favicon,
            ]);
        }

        return redirect()->back()->with('success', 'Company information saved successfully.');
    }

}
