<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CustomRedirectIfAuthenticated {
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response {

        if (Auth::check() && Auth::user()->email_verified_at != null) {

            return to_route('dashboard.welcome');
        } elseif (Auth::check() && Auth::user()->email_verified_at == null) {

            return to_route('verify')->with(['name' => Auth::user()->name]);
        }

        return $next($request);
    }

}
