<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class JournalCategory extends Model {
    protected $guarded = [];

    public function journal() {
        return $this->belongsTo(Journal::class, 'journal_id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->created_by = Auth::id();
        });

        static::updating(function ($model) {
            $model->updated_by = Auth::id();
        });

        static::saved(function ($model) {
            self::refreshJournalCache($model);
        });

        static::deleted(function ($model) {
            self::clearJournalCache($model);
        });
    }

    protected static function refreshJournalCache(self $model): void
    {
        if (! $model->journal) {
            return;
        }

        Cache::forever(
            Journal::cacheKey($model->journal->slug),
            Journal::with('journalCategories')->find($model->journal_id)
        );

        Cache::forget(Journal::listCacheKey());
    }

    protected static function clearJournalCache(self $model): void
    {
        if (! $model->journal) {
            return;
        }

        Cache::forget(Journal::cacheKey($model->journal->slug));
        Cache::forget(Journal::listCacheKey());
    }
}
