<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MenuItem extends Model {
    protected $guarded = [];

    public function subMenus() {
        return $this->hasMany(MenuItem::class, 'parent_id');
    }

    public function parentMenu() {
        return $this->belongsTo(MenuItem::class, 'parent_id');
    }

    public function menuPermissions() {
        return $this->hasMany(MenuPermission::class);
    }
}
