<?php

namespace App\Providers;

use App\Models\User;
use Illuminate\Auth\Access\Response;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

// use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider {
    /**
     * Register services.
     */
    public function register(): void {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void {
        Gate::define('admin-only', function (User $user) {
            return $user->role === 'Admin'
            ? Response::allow()
            : Response::deny('Admins only.');
        });
        
        Gate::define('author-only', function (User $user) {
            return $user->role === 'Author'
            ? Response::allow()
            : Response::deny('Authors only.');
        });
    }
}
