@extends('layouts.master')
@section('title', 'Create new journal')
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.9.1/summernote-bs5.min.css" />
@endsection

@section('content')
    <div class="row">
        <h3 class="p-0">Create new journal</h3>
    </div>

    <div class="row">


        <div class="card">
            <x-back-button :route="route('journals.index')"></x-back-button>
            <div class="row justify-content-center">
                <div class="col-md-9">

                    <div class="card shadow-sm">
                        <div class="card-header">
                            <h5 class="mb-0">Assign Editors / Reviewers</h5>
                        </div>

                        <div class="card-body">

                            @if (session('success'))
                                <div class="alert alert-success">
                                    {{ session('success') }}
                                </div>
                            @endif

                            <form method="POST" action="{{ route('journal-assignments.store') }}">
                                @csrf

                                {{-- Journal --}}
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Journal</label>
                                        <select id="journal_id" name="journal_id" class="form-select" required>
                                            <option value="">-- Select Journal --</option>
                                            @foreach ($journals as $journal)
                                                <option value="{{ $journal->id }}">
                                                    {{ $journal->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    {{-- Role --}}
                                    <div class="col-md-6">
                                        <label class="form-label">Role</label>
                                        <select id="role" name="role" class="form-select" required>
                                            <option value="">-- Select Role --</option>
                                            <option value="Editor">Editor</option>
                                            <option value="Reviewer">Reviewer</option>
                                        </select>
                                    </div>
                                </div>

                                {{-- Users --}}
                                <div id="user-section" class="d-none">
                                    <hr>
                                    <h6 class="mb-3">Users</h6>

                                    <div id="user-list" class="row">
                                        {{-- dynamically loaded --}}
                                    </div>
                                </div>

                                <div class="mt-4 d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary">
                                        Save Assignment
                                    </button>
                                </div>

                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    </div>
@endsection
@section('js')
    <script>
        const journalSelect = document.getElementById('journal_id');
        const roleSelect = document.getElementById('role');
        const userSection = document.getElementById('user-section');
        const userList = document.getElementById('user-list');

        function loadUsers() {
            const journalId = journalSelect.value;
            const role = roleSelect.value;

            if (!journalId || !role) {
                userSection.classList.add('d-none');
                return;
            }

            fetch(`{{ route('journal-assignments.users') }}?journal_id=${journalId}&role=${role}`)
                .then(res => res.json())
                .then(data => {
                    userList.innerHTML = '';
                    userSection.classList.remove('d-none');

                    data.users.forEach(user => {
                        const checked = data.assigned.includes(user.id) ? 'checked' : '';

                        userList.innerHTML += `
                    <div class="col-md-4 mb-2">
                        <div class="form-check">
                            <input class="form-check-input"
                                   type="checkbox"
                                   name="users[]"
                                   value="${user.id}"
                                   id="user_${user.id}"
                                   ${checked}>
                            <label class="form-check-label" for="user_${user.id}">
                                ${user.name}
                            </label>
                        </div>
                    </div>
                `;
                    });
                });
        }

        journalSelect.addEventListener('change', loadUsers);
        roleSelect.addEventListener('change', loadUsers);
    </script>
@endsection
