@extends('layouts.master')
@section('title', 'Edit existing journal category')
@section('css')
@endsection

@section('content')
    <div class="row">
        <h3 class="p-0">Edit existing journal</h3>
    </div>

    <div class="row">


        <div class="card">
            <x-back-button :route="route('journal-categories.index')"></x-back-button>
            <div class="card-body">
                <form action="{{ route('journal-categories.update', $data) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row app-form">
                        <div class="col-3 mb-3">
                            <label class="form-label" for="journal_id">journal*</label>
                            <select name="journal_id" class="select-example form-select select-basic" required>
                                <option value="">Select option</option>
                                @foreach ($journals as $journal)
                                    <option value="{{ $journal->id }}"
                                        {{ $data->journal_id == $journal->id ? 'selected' : '' }}>
                                        {{ $journal->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12 mb-3">
                            <label class="form-label" for="name">Journal Category Name*</label>
                            <input type="text" name="name" id="name" class="form-control"
                                value="{{ $data->name }}" required>
                        </div>

                        <x-submit-button></x-submit-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
@endsection
