@extends('layouts.master')
@section('title', 'Create new journal statistic')
@section('css')
@endsection

@section('content')
    <div class="row">
        <h3 class="p-0">Create new journal statistic</h3>
    </div>

    <div class="row">


        <div class="card">
            <x-back-button :route="route('journal-statistics.index')"></x-back-button>
            <div class="card-body">
                <form action="{{ route('journal-statistics.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row app-form">

                        <div class="col-12 mb-3">
                            <label class="form-label" for="journal_id">journal*</label>
                            <select name="journal_id" class="select-example form-select select-basic" required>
                                <option value="">Select option</option>
                                @foreach ($journals as $journal)
                                    <option value="{{ $journal->id }}">
                                        {{ $journal->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="volume">Journal Volume*</label>
                            <input type="text" name="volume" id="volume" class="form-control" value=""
                                required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="issue">Journal Volume Issue*</label>
                            <input type="text" name="issue" id="issue" class="form-control" value=""
                                required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="start_date">Start Date*</label>
                            <input type="date" name="start_date" id="start_date" class="form-control" value=""
                                required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="end_date">End Date*</label>
                            <input type="date" name="end_date" id="end_date" class="form-control" value=""
                                required>
                        </div>

                        <x-submit-button></x-submit-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
@endsection
