@extends('layouts.master')
@section('title', 'Edit existing journal statistic')
@section('css')
@endsection

@section('content')
    <div class="row">
        <h3 class="p-0">Edit existing journal statistic</h3>
    </div>

    <div class="row">


        <div class="card">
            <x-back-button :route="route('journal-statistics.index')"></x-back-button>
            <div class="card-body">
                <form action="{{ route('journal-statistics.update', $data) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row app-form">
                        <div class="col-3 mb-3">
                            <label class="form-label" for="journal_id">journal*</label>
                            <select name="journal_id" class="select-example form-select select-basic" required>
                                <option value="">Select option</option>
                                @foreach ($journals as $journal)
                                    <option value="{{ $journal->id }}"
                                        {{ $data->journal_id == $journal->id ? 'selected' : '' }}>
                                        {{ $journal->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="volume">Journal Volume*</label>
                            <input type="text" name="volume" id="volume" class="form-control"
                                value="{{ $data->volume }}" required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="issue">Journal Volume Issue*</label>
                            <input type="text" name="issue" id="issue" class="form-control"
                                value="{{ $data->issue }}" required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="start_date">Start Date*</label>
                            <input type="date" name="start_date" id="start_date" class="form-control"
                                value="{{ $data->start_date->format('Y-m-d') }}" required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="end_date">End Date*</label>
                            <input type="date" name="end_date" id="end_date" class="form-control"
                                value="{{ $data->end_date->format('Y-m-d') }}" required>
                        </div>

                        <x-submit-button></x-submit-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
@endsection
