{{-- branch/index-data-rows.blade.php --}}
@foreach ($data as $item)
    <tr>
        <td>
            @if ($item->icon)
                <img alt="avatar" class="img-fluid b-r-10" src="{{ asset($item->icon) }}" style="height: 35px;">
            @else
                <img alt="avatar" class="img-fluid b-r-10" src="{{ asset('assets/images/avatar/3.png') }}"
                    style="height: 35px;">
            @endif
        </td>
        <td style="color: {{ $item->color_family }}">{{ $item->name }}</td>
        <td>{{ $item->abr_name }}</td>
        <td>
            <b>Digital: </b>{{ $item->issn_digital }}, <br>
            <b>Print: </b>{{ $item->issn_print }}
        </td>
        <td>{{ $item->coden }}</td>
        <td>{{ $item->launched_year }}</td>
        <td>
            @if ($item->j_format)
                <a href="{{ asset($item->j_format) }}" target="_blank">View Current Format</a>
            @else
                N/A
            @endif
        </td>
        <td>
            <div class="d-flex justify-content-around">
                <x-show-button :route="route('journals.show', $item->id)"></x-show-button>
                <x-edit-button :route="route('journals.edit', $item->id)"></x-edit-button>
                <x-delete-button :route="route('journals.destroy', $item)"></x-delete-button>
            </div>
        </td>
    </tr>
@endforeach
