<div class="app-logo">
    <a class="logo d-inline-block" href="index.html">
        <img alt="#" src="{{ asset('assets/images/logo/1.png') }}">
    </a>

    <span class="bg-light-primary toggle-semi-nav d-flex-center">
        <i class="ti ti-chevron-right"></i>
    </span>

    <div class="d-flex align-items-center nav-profile p-3">
        <span class="h-45 w-45 d-flex-center b-r-10 position-relative bg-danger m-auto">
            <img alt="avatar" class="img-fluid b-r-10"
                src="{{ asset(auth()->user()->image ?? 'assets/images/avatar/woman.jpg') }}">
            <span class="position-absolute top-0 end-0 p-1 bg-success border border-light rounded-circle"></span>
        </span>
        <div class="flex-grow-1 ps-2">
            <h6 class="text-primary mb-0"> {{ auth()->user()->name }}</h6>
            <p class="text-muted f-s-12 mb-0">{{ auth()->user()->role }}</p>
        </div>


        <div class="dropdown profile-menu-dropdown">
            <a aria-expanded="false" data-bs-auto-close="true" data-bs-placement="top" data-bs-toggle="dropdown"
                role="button">
                <i class="ti ti-settings fs-5"></i>
            </a>
            <ul class="dropdown-menu">
                <li class="dropdown-item">
                    <a class="f-w-500" href="profile.html" target="_blank">
                        <i class="ph-duotone  ph-user-circle pe-1 f-s-20"></i> Profile Details
                    </a>
                </li>
                <li class="dropdown-item">
                    <a class="f-w-500" href="setting.html" target="_blank">
                        <i class="ph-duotone  ph-gear pe-1 f-s-20"></i> Settings
                    </a>
                </li>
                <li class="dropdown-item">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <a class="f-w-500" href="#">
                                <i class="ph-duotone  ph-detective pe-1 f-s-20"></i> Incognito
                            </a>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="form-check form-switch">
                                <input class="form-check-input form-check-primary" id="incognitoSwitch" type="checkbox">
                            </div>
                        </div>
                    </div>
                </li>
                <li class="dropdown-item">
                    <a class="mb-0 text-secondary f-w-500" href="sign_up.html" target="_blank">
                        <i class="ph-bold  ph-plus pe-1 f-s-20"></i> Add account
                    </a>
                </li>

                <li class="app-divider-v dotted py-1"></li>

                <li class="dropdown-item">
                    <a class="mb-0 text-danger" href="sign_in.html" target="_blank">
                        <i class="ph-duotone  ph-sign-out pe-1 f-s-20"></i> Log Out
                    </a>
                </li>
            </ul>
        </div>

    </div>
</div>
<div class="app-nav" id="app-simple-bar">
    <ul class="main-nav p-0 mt-2">
        @can('author-only')
            <li class="menu-title"><span>Author Menu</span></li>
            <li class="no-sub  ">
                <a href="">
                    <i class="fa-solid fa-book"></i> My Journals
                </a>
            </li>
            <li class="no-sub  ">
                <a href="{{ route('author.journal-submission.createOrEdit') }}">
                    <i class="fa-solid fa-book"></i> Journal Submission
                </a>
            </li>
        @endcan
        @can('admin-only')
            <li class="menu-title"><span>System Administrator</span></li>
            <li>
                <a aria-expanded="false" data-bs-toggle="collapse" href="#journals-menus">
                    <i class="fa-solid fa-journals"></i>
                    Journal Operations
                </a>
                <ul class="collapse" id="journals-menus">
                    <li class=""><a href="{{ route('journal-assignments.create') }}">Journal Assign</a></li>
                    <li class="{{ activeMenu('journal-statistics') }}"><a href="{{ route('journal-statistics.index') }}">Journal Statistics</a></li>
                    <li class="{{ activeMenu('journals') }}"><a href="{{ route('journals.index') }}">All journals</a></li>
                    <li class="{{ activeMenu('journal-categories') }}"><a href="{{ route('journal-categories.index') }}">Journal Categories</a></li>
                </ul>
            </li>
            <li>
                <a aria-expanded="false" data-bs-toggle="collapse" href="#users-menus">
                    <i class="fa-solid fa-users"></i>
                    User Operations
                </a>
                <ul class="collapse" id="users-menus">
                    <li class="{{ activeMenu('users') }}"><a href="{{ route('users.index') }}">All Users</a></li>
                    <li class="{{ activeMenu('site-designations') }}"><a
                            href="{{ route('site-designations.index') }}">Site
                            Designation</a></li>
                </ul>
            </li>
            <li class="no-sub">
                <a href="{{ route('company-infos.index') }}">
                    <i class="fa-solid fa-list"></i> Company Info
                </a>
            </li>
            {{-- <li class="no-sub">
                    <a href="{{ route('units.index') }}">
                        <i class="fa-solid fa-universal-access"></i> unit
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('products.index') }}">
                        <i class="fa-brands fa-product-hunt"></i> Product
                    </a>
                </li>
                <li class="no-sub">
                    <a href="{{ route('permission.index') }}">
                        <i class="fa-brands fa-accessible-icon"></i> Access Permission
                    </a>
                </li> --}}
        @endcan
        @if (session()->has('branch_id'))
            @foreach (menuItems() as $menu)
                @if ($menu->subMenus->isNotEmpty())
                    <li>
                        <a aria-expanded="false" data-bs-toggle="collapse" href="#{{ $menu->slug }}">
                            <i class="{{ $menu->class_name }}"></i>
                            {{ $menu->name }}
                        </a>
                        <ul class="collapse" id="{{ $menu->slug }}">
                            @foreach ($menu->subMenus as $sub)
                                <li><a href="{{ route($sub->slug) }}">{{ $sub->name }}</a></li>
                            @endforeach
                        </ul>
                    </li>
                @else
                    <li class="no-sub {{ activeMenu($menu->slug) }} ">
                        <a href="{{ route($menu->slug) }}">
                            <i class="{{ $menu->class_name }}"></i> {{ $menu->name }}
                        </a>
                    </li>
                @endif
            @endforeach
        @endif
        <hr>
        <form action="{{ route('logout') }}" method="POST">
            @csrf
            <button type="submit" class="btn btn-danger btn-block"
                style="width: 100%;border-radius: 0;text-align: left;"><i
                    class="fa-solid fa-arrow-left-from-bracket"></i>Logout</button>
        </form>
    </ul>
</div>

<div class="menu-navs">
    <span class="menu-previous"><i class="ti ti-chevron-left"></i></span>
    <span class="menu-next"><i class="ti ti-chevron-right"></i></span>
</div>
