@extends('layouts.master')
@section('title', 'Access Permission')
@section('css')
@endsection

@section('content')
    <div class="container">
        <h2>Access Permissions</h2>


        <!-- Permission Form -->
        <form action="{{ route('permission.store') }}" method="POST">
            @csrf
            <div class="row">

                <div class="col-6">

                    <div class="form-group">
                        <label for="user_id">Select User:</label>
                        <select name="user_id" id="user_id" class="form-control">
                            <option value="">-- Select User --</option>
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->role }})</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-6">

                    <div class="form-group">
                        <label for="branch_id">Select Branch:</label>
                        <select name="branch_id" id="branch_id" class="form-control">
                            <option value="">-- Select Branch --</option>
                            @foreach ($branches as $branch)
                                <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div id="menu-permissions" class="mt-3"></div>

                <x-submit-button></x-submit-button>
        </form>
    </div>


@endsection
@section('js')

    <script>
        $('#user_id, #branch_id').change(function() {
            updateMenuPermissions();
        });

        function updateMenuPermissions() {
            const userId = $('#user_id').val();
            const branchId = $('#branch_id').val();

            if (!userId || !branchId) {
                return;
            }

            $.ajax({
                url: '/menu-permissions/' + userId + '/' + branchId,
                method: 'GET',
                success: function(response) {
                    $('#menu-permissions').html(response.html);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching menu permissions:', error);
                }
            });
        }
    </script>
@endsection
