@extends('layouts.master')
@section('title', 'User lists')
@section('css')
@endsection

@section('content')
    <div class="row">
        <h3 class="p-0">Your user</h3>
    </div>

    <div class="row table-section">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <x-create-new-button :route="route('users.create')"></x-create-new-button>

                    <x-list-search></x-list-search>
                </div>
                <br>
                <div id="tableData" class="table-responsive app-scroll">
                    <div>
                        <table class="table table-bordered table-striped table-responsive align-middle mb-0">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>Full Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Activity</th>
                                    <th>Designation</th>
                                    <th>Engaged</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="table-body">
                                @include('user.index-data-rows')
                            </tbody>
                        </table>
                        <div class="pagination-links">
                            {{-- Display custom pagination --}}
                            {{ $data->links('vendor.pagination.custom-pagination') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {

            function fetchData(searchValue, page = 1) {
                $.ajax({
                    url: "{{ route('users.index') }}",
                    type: 'GET',
                    data: {
                        search: searchValue,
                        page: page
                    },
                    success: function(response) {
                        $('#table-body').html(response.rows);
                        $('#pagination-links').html(response.links);
                    }
                });
            }

            $('#search').on('input', function() {
                var searchValue = $(this).val();

                if (searchValue.length >= 3 || searchValue.length === 0) {
                    fetchData(searchValue);
                }
            });

            $('#resetSearch').on('click', function() {
                $('#search').val('');
                fetchData('');
            });

            $(document).on('click', '#pagination-links a', function(e) {
                e.preventDefault();
                var page = $(this).attr('href').split('page=')[1];
                var searchValue = $('#search').val();

                fetchData(searchValue, page);
            });
        });
    </script>
@endsection
