<?php

use App\Http\Controllers\AccessPermissionController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AuthorJournalSubmissionController;
use App\Http\Controllers\CompanyInfoController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\JournalCategoryController;
use App\Http\Controllers\JournalController;
use App\Http\Controllers\JournalStatisticController;
use App\Http\Controllers\JournalUserAssignmentController;
use App\Http\Controllers\SiteDesignationController;
use App\Http\Controllers\UserController;
use App\Models\JournalCategory;
use App\Models\JournalStatistic;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return 'ok';
})->name('home');

Route::controller(AuthController::class)->middleware('guest')->group(function () {
    Route::get('/signup', 'register')->name('register');
    Route::post('/registration', 'registration')->name('registration');

    Route::get('/-jpr', 'root')->name('root');
    Route::post('/_login', 'login')->name('login');

    Route::get('/forgot-password', 'forgotPassword')->name('forgotPassword');
    Route::post('/store-forgot-password', 'storeForgotPassword')->name('storeForgotPassword');

    Route::get('/reset-password/{token}', 'resetPassword')->name('resetPassword');
    Route::post('/store-reset-password', 'storeResetPassword')->name('storeResetPassword');

    Route::get('/verify', 'verify')->name('verify');
    Route::post('/store-verify-account', 'storeVerifyAccount')->name('storeVerifyAccount');
    Route::get('/verify-account', 'verifyAccount')->name('verifyAccount');
});

Route::middleware(['auth'])->group(function () {
    Route::controller(AuthController::class)->group(function () {

        Route::post('/logout', 'logout')->name('logout');
    });
    Route::controller(DashboardController::class)->name('dashboard.')->group(function () {
        Route::get('/welcome', 'welcome')->name('welcome');
        Route::get('/dashboard', 'dashboard')->name('dashboard');
    });
});

Route::middleware([
    'auth',
    'can:author-only',
])
    ->prefix('/author')
    ->name('author.')
    ->group(function () {
        Route::controller(AuthorJournalSubmissionController::class)
            ->prefix('/journal-submissions')
            ->name('journal-submission.')
            ->group(function () {
                Route::get('', 'index')->name('index');
                Route::get('/create-or-edit/{id?}', 'createOrEdit')->name('createOrEdit');
                Route::post('/store-or-update/{id?}', 'storeOrUpdate')->name('storeOrUpdate');
            });
    });
Route::middleware([
    'auth',
    'can:admin-only',
])
    ->prefix('/admin')
    ->group(function () {
        Route::resource('users', UserController::class);
        Route::resource('site-designations', SiteDesignationController::class);
        Route::resource('journals', JournalController::class);
        Route::resource('journal-categories', JournalCategoryController::class);

        Route::get('journal-assignments', [JournalUserAssignmentController::class, 'create'])
            ->name('journal-assignments.create');
        Route::post('journal-assignments', [JournalUserAssignmentController::class, 'store'])
            ->name('journal-assignments.store');
        Route::get('journal-assignments/users', [JournalUserAssignmentController::class, 'getUsers'])
            ->name('journal-assignments.users');

        Route::resource('company-infos', CompanyInfoController::class);
        Route::resource('journal-statistics', JournalStatisticController::class);

        Route::controller(AccessPermissionController::class)->name('permission.')->group(function () {
            Route::get('access-permission', 'index')->name('index');
            Route::post('access-permission', 'store')->name('store');

            //ajax request
            Route::get('menu-permissions/{userId}/{branchId}', 'fetchMenuPermissionsHtml')->name('fetchMenuPermissions');
        });
    });

Route::fallback(function () {
    return response()->view('errors.404', [], 404);
});

//ajax routes
Route::get('/get-journal-categories/{journal_id}', function ($journal_id) {
    $categories = JournalCategory::where('journal_id', $journal_id)
        ->orderBy('name')
        ->get();

    return response()->json($categories);
})->name('get.journal.categories');

Route::get('/get-journal-statistics/{journal_id}', function ($journal_id) {
    $statistics = JournalStatistic::where('journal_id', $journal_id)
        ->whereDate('start_date', '<=', now())
        ->whereDate('end_date', '>=', now())
        ->orderBy('volume', 'desc')
        ->orderBy('issue', 'desc')
        ->get();

    return response()->json($statistics);
})->name('get.journal.statistics');